<?php

class TubeSource {
	private $sparqlClient;
	
	public function getAllLines() {
		
		$returnArray = array();
		
		$query = '
			PREFIX dc: <http://purl.org/dc/elements/1.1/>
			PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
			FROM <tube_model2.rdf>
			SELECT DISTINCT ?lineName
			WHERE {
			   ?type rdfs:type <http://space.frot.org/rdf/space.owl#Tube_Line> .
   			   ?type dc:title ?lineName
			} 
			ORDER BY ?lineName';
			
		$result = $this->sparqlClient->sparqlQuery($query);
		
		if ($result != "false") {
			foreach ($result as $line) {					
				if ($line != "") {
					$lineObj = new Line();
					$lineObj->setLineName($line['?lineName']->getLabel());	
					array_push($returnArray, $lineObj);
				}
			}
		}
		
		return $returnArray;
//Rob Seano
	}

	public function getStationsByLine($lineName) {
		$returnArray = array();
		
		$query = '
			PREFIX : <http://xmlns.com/foaf/0.1/>
			PREFIX geo: <http://www.w3.org/2003/01/geo/wgs84_pos#>
			PREFIX dc: <http://purl.org/dc/elements/1.1/>
			PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>

			SELECT DISTINCT ?stationName ?lat ?long
			FROM <tube_model2.rdf>
			WHERE {
			   ?line dc:title "' . $lineName . '" .
			   ?line rdf:subject ?infourl .
  			   ?infourl dc:title ?stationName .
			   ?infourl geo:lat ?lat .
			   ?infourl geo:long ?long
			} ';
			
		$result = $this->sparqlClient->sparqlQuery($query);
		
		if ($result != "false") {
			foreach ($result as $station) {					
				if ($station != "") {
					$stationObj = new Station();
					$stationObj->setStationName($station['?stationName']->getLabel());	
					$stationObj->setLat($station['?lat']->getLabel());
					$stationObj->setLong($station['?long']->getLabel());
					array_push($returnArray, $stationObj);
				}
			}
		}
		
		return $returnArray;
		
	}

	public function __construct(&$sparqlClient, $sourceFile) {
		$this->sparqlClient = $sparqlClient;
		$this->sparqlClient->load($sourceFile);
	}
	
}

?>
